# -*- coding: utf-8 -*-
""" capellaScript -- Matthias Leopold
>>> MassOptimizer

Korrektur von Liedtexten

<<<

History: 20.08.07 - Liedtextoptimierung


"""


from caplib.capDOM import ScoreChange
import os, re, string, sys, tempfile
sys.path.append(os.path.join(getPersonalDataDir(), 'scripts', 'user-scripts'))
import Optimizer, Tools
from Tools import latin1_e
from Tools import latin1_d
from Tools import createNewChild
from Tools import getElement

# Liste der Teile (Kyrie eleison etc.), aus denen die Messe/der Messeteil besteht
parts = []


section = {\
'Kyrie'                            : ['Kyrie eleison', 'Christe eleison'], \
'Gloria'                           : ['Gloria in excelsis', 'Et in terra pax', 'Laudamus te', 'Gratias agimus tibi', 'Domine Deus', 'Qui tollis peccata mundi', 'Qui sedes ad dexteram Patris', 'Quoniam tu solus sanctus' , 'Cum Sancto Spiritu'], \
'Credo'                            : ['Credo in unum Deum', 'Patrem omnipotentem', 'Et in unum Dominum', 'Et incarnatus est', 'Crucifixus', 'Et resurrexit', 'Et in Spiritum sanctum Dominum', 'Confiteor', 'Et expecto'], \
'Sanctus'                          : ['Sanctus', 'Osanna in excelsis'], \
'Benedictus'                       : ['Benedictus', 'Osanna in excelsis'], \
'Agnus Dei'                        : ['Agnus Dei', 'Dona nobis pacem'] \
}

section_texts = { \
'Kyrie eleison'                    : 'ky-ri-e (e-lei-son|e-le-i-son)', \
'Christe eleison'                  : 'chri-ste (e-lei-son|e-le-i-son)', \
\
'Gloria in excelsis'               : 'glo-ri-a in ex-cel-sis De-o', \
'Et in terra pax'                  : 'et in ter-ra pax ho-mi-ni-bus bo-nae vo-lun-ta-tis', \
'Laudamus te'                      : 'lau-da-mus te be-ne-di-ci-mus te a-do-ra-mus te glo-ri-fi-ca-mus te', \
'Gratias agimus tibi'              : 'gra-ti-as a-gi-mus ti-bi pro-pter ma-gnam glo-ri-am tu-am', \
'Domine Deus'                      : 'Do-mi-ne De-us Rex (cae-le-stis|coe-le-stis) De-us Pa-ter o-mni-po-tens Do-mi-ne Fi-li u-ni-ge-ni-te (Ie-su|Je-su) Chri-ste Do-mi-ne De-us A-gnus De-i Fi-li-us Pa-tris', \
'Qui tollis peccata mundi'         : 'qui tol-lis pec-ca-ta mun-di mi-se-re-re no-bis qui tol-lis pec-ca-ta mun-di su-sci-pe de-pre-ca-ti-o-nem no-stram', \
'Qui sedes ad dexteram Patris'     : 'qui se-des ad (dex-te-ram|dex-tram) Pa-tris mi-se-re-re no-bis', \
'Quoniam tu solus sanctus'         : 'quo-ni-am tu so-lus san-ctus tu so-lus Do-mi-nus tu so-lus Al-tis-si-mus (Ie-su|Je-su) Chri-ste', \
'Cum Sancto Spiritu'               : 'cum san-cto Spi-ri-tu in glo-ri-a De-i Pa-tris a-men', \
\
'Credo in unum Deum'               : 'cre-do in u-num De-um', \
'Patrem omnipotentem'              : 'pa-trem o-mni-po-ten-tem fa-cto-rem (cae-li|coe-li) et ter-rae vi-si-bi-li-um o-mni-um et in-vi-si-bi-li-um', \
'Et in unum Dominum'               : 'et in u-num Do-mi-num Je-sum Chri-stum Fi-li-um De-i u-ni-ge-ni-tum et ex Pa-tre na-tum an-te o-mni-a (se-cu-la|sae-cu-la) De-um de De-o lu-men de lu-mi-ne De-um ve-rum de De-o ve-ro ge-ni-tum non fa-ctum con-sub-stan-ti-a-lem Pa-tri per quem o-mni-a fa-cta sunt qui pro-pter nos ho-mi-nes et pro-pter no-stram sa-lu-tem de-scen-dit de (coe-lis|cae-lis)', \
'Et incarnatus est'                : 'et in-car-na-tus est de Spi-ri-tu san-cto ex Ma-ri-a vir-gi-ne et ho-mo fa-ctus est', \
'Crucifixus'                       : 'cru-ci-fi-xus e-ti-am pro no-bis sub Pon-ti-o Pi-la-to pas-sus et se-pul-tus est', \
'Et resurrexit'                    : 'et re-sur-re-xit ter-ti-a di-e se-cun-dum scri-ptu-ras et a-scen-dit in (coe-lum|cae-lum) se-det ad dex-te-ram Pa-tris et i-te-rum ven-tu-rus est cum glo-ri-a ju-di-ca-re vi-vos et mor-tu-os (cu-jus|cu-is) re-gni non e-rit fi-nis', \
'Et in Spiritum sanctum Dominum'   : 'et in Spi-ri-tum san-ctum Do-mi-num et vi-vi-fi-can-tem qui ex Pa-tre Fi-li-o-que pro-ce-dit qui cum Pa-tre et Fi-li-o si-mul a-do-ra-tur et con-glo-ri-fi-ca-tur qui lo-cu-tus est per Pro-phe-tas et u-nam san-ctam ca-tho-li-cam et a-po-sto-li-cam ec-cle-si-am', \
'Confiteor'                        : 'con-fi-te-or u-num ba-pti-sma in re-mis-si-o-nem pec-ca-to-rum', \
'Et expecto'                       : 'et (ex-pe-cto|ex-spe-cto) re-sur-re-cti-o-nem mor-tu-o-rum et vi-tam ven-tu-ri (sae-cu-li|se-cu-li) a-men a-men', \
\
'Sanctus'                          : 'san-ctus san-ctus san-ctus Do-mi-nus De-us Sa-ba-oth ple-ni sunt (coe-li|cae-li) et ter-ra glo-ri-a (tu-a|tu-e)', \
'Osanna in excelsis'               : '(ho-san-na|o-san-na) in ex-cel-sis', \
\
'Benedictus'                       : 'be-ne-di-ctus qui ve-nit in no-mi-ne Do-mi-ni', \
\
'Agnus Dei'                        : 'a-gnus De-i qui tol-lis pec-ca-ta mun-di mi-se-re-re no-bis a-gnus De-i qui tol-lis pec-cata mun-di', \
'Dona nobis pacem'                 : 'do-na no-bis pa-cem' \
}


replaces = [ \
# nächste Zeile soll nicht funktionieren
['H', 'll'], \
['J', 'l'], \
['I', 'l'], \
['ì', 'l'], \
['i', 'l'], \
['t', 'l'], \
['í', 'l'], \
['1', 'l'], \
[']', 'l'], \
['[', 'l'], \
['!', 'l'], \
['1', 'l'], \
['\\', 'l'], \
['li', 'h'], \
['in', 'm'], \
['ln', 'm'], \
['rn', 'm'], \
['tn', 'm'], \
['ii', 'n'], \
['ri', 'n'], \
['rl', 'n'], \
['c', 'o'], \
['C', 'o'], \
['e', 'o'], \
['ò', 'o'], \
['ö', 'o'], \
['ó', 'o'], \
['°', 'o'], \
['F', 'p'], \
['à', 'a'], \
['ä', 'a'], \
['á', 'a'], \
['ù', 'u'], \
['ü', 'u'], \
['ú', 'u'], \
['5', 's'], \
[' ', ''], \
]


def debug(text='Text'):
  label = Label(text)
  box = VBox([label],padding=1)
  dlg = Dialog('Debugger', box)
  if dlg.run():
    return True
  else:
    return False


# Prüft, ob es mehr Systeme im Mustersystem gibt, als irgendwann angezeigt werden
# Wenn ja -> Fehlermeldung
def system_check(score):
  global doc  # Referenz auf das Dokument
  doc = score.parentNode
  layout_systems = 0
  max_systems = 0
  for staffLayout in score.getElementsByTagName('staffLayout'):
    layout_systems += 1
  for system in score.getElementsByTagName('system'):
    current_systems = 0
    for staff in system.getElementsByTagName('staff'):
      current_systems += 1
    if current_systems > max_systems:
      max_systems = current_systems
  if max_systems < layout_systems :
    debug('Vermutlich Fehler im Mustersystem!!!')




def normalize_text(dword):
  word = dword
  changes = 1
  while (changes == 1):
    org_word = word
    changes = 0
    for pair in replaces:
      word = word.replace(pair[0], pair[1], 5)
    if org_word != word:
      changes = 1
    return word


def prefixes_suffixes(text):
  org_text = text
  s = re.compile(r'^(["(]*)')
  t = re.compile(r'([,;.:!?)"]*)$')
  text = s.sub('', text)
  text = t.sub('', text)
  ss = s.search(org_text)
  text_prefix = ss.group(0)
  tt = t.search(org_text)
  text_suffix = tt.group(0)
  return [text_prefix, text, text_suffix]


def get_actual_texts_keys():
  # In dem Hash stehen die Dialogelemente, Schlüssel ist "Agnus dei" usw.
  checkBoxes = {} # 1 oder 0 je nach Auswahl
  checkBoxList = []
  section_texts_keys = section_texts.keys()
  sorted_section_texts_keys = section_texts_keys#.sort()
  sorted_section_texts_keys = [\
'Kyrie eleison', 'Christe eleison', \
'Gloria in excelsis', 'Et in terra pax', 'Laudamus te', 'Gratias agimus tibi', 'Domine Deus', 'Qui tollis peccata mundi', 'Qui sedes ad dexteram Patris', 'Quoniam tu solus sanctus' , 'Cum Sancto Spiritu', \
'Credo in unum Deum', 'Patrem omnipotentem', 'Et in unum Dominum', 'Et incarnatus est', 'Crucifixus', 'Et resurrexit', 'Et in Spiritum sanctum Dominum', 'Confiteor', 'Et expecto', \
'Sanctus', 'Osanna in excelsis', \
'Benedictus', 'Osanna in excelsis', \
'Agnus Dei', 'Dona nobis pacem']
  for section_text in sorted_section_texts_keys:
    checkBox = CheckBox(section_text, value=0)
    checkBoxList.append(checkBox)
    checkBoxes[section_text] = checkBox
  vbox  = VBox(checkBoxList, text='', padding=4)
  dlg = Dialog('Liedtext korrigieren: ', vbox)
  solution = [] # 'Credo in unum Deum', 'Patrem omnipotentem'
  if dlg.run():
    for checkBoxKey in checkBoxes.keys():
      if checkBoxes[checkBoxKey].value() == 1:
        solution.append(checkBoxKey)
  return solution

def get_actual_text():
  label = Label('Text: ', width = 6)
  edit = Edit('', width=60)
  vbox  = VBox([label, edit], text='', padding=4)
  dlg = Dialog('Eigener Liedtext', vbox)
  solution = ''
  if dlg.run():
    solution = edit.value()
  return solution


# Feststellen welchen Teilen die Liedtexte entsprechen und entsprechende
# Korrektur der Liedtexte
def update_parts(score):
  s = re.compile(r'[\- \|\(\)]+')
  t1 = re.compile(r'^[^A-Za-zÄÖÜäöüß]*')
  t2 = re.compile(r'[^A-Za-zÄÖÜäöüß]*$')
  all_words = {}   # Alle Wörter, die es überhaupt gibt
  verse_words = {} # Alle Wörterm, die im aktuellen Liedtext vorkommen
  # Hash aller vorgegebenen Liedtextsilben (Wert immer 1)
  # Hier werden alle Liedtexte aufgenommen, die in den obigen (Messe-)Texthashes
  # definiert wurden
  for section_text_key in section_texts.keys():
    section_text = section_texts[section_text_key]
    for section_word in s.split(section_text):
      all_words[section_word.lower()] = 1
  # Hash alle Liedtextsilben des aktuellen Stückes (Wert immer 1)
  # Dabei bezifferte Bässe überspringen
  for voice in score.getElementsByTagName('voice'):
    lyricsSettings = getElement(voice, 'lyricsSettings')
    if lyricsSettings:
      font = getElement(lyricsSettings, 'font')
      if font:
        if latin1_e(font.getAttribute('color')) == '993200':
          continue
    for verse in voice.getElementsByTagName('verse'):
      if verse.hasChildNodes() and not(verse.lastChild is None):
        text = latin1_e(verse.lastChild.nodeValue)
        text = t1.sub('', text)
        text = t2.sub('', text)
        verse_words[text] = 1
  # Vergleiche nun alle Wörter des aktuellen Stückes mit jeweils einem
  # Messeabschnitt und bestimme daraus, ob das Stücke jeweilige Messeteile
  # zum Inhalt hat
  actual_section_texts = []  # Tatsächlich vorkommene Messeteile
  actual_section_words = {}  # Tatsächlich vorkommene Wörter
  for section_text_key in section_texts.keys():
    section_words = {}
    section_text = section_texts[section_text_key]
    for section_word in s.split(section_text):
      section_words[section_word.lower()] = 1
    positive = 0
    negative = 0
    for verse_word in verse_words.keys():
      if section_words.has_key(verse_word.lower()):
        positive += 1  # Wörter sollten stehen und stehen auch
      elif all_words.has_key(verse_word.lower()):
        negative += 1  # Wort existiert tatsächlich, aber nicht hier
    # Die aktuelle Vorlage entspricht den Liedtexten
    # Diesen Messeteil einfließen lassen in die Menge aller gültigen Messeteile
    #debug(section_text_key+'  %d  %d  %d' % (positive, negative, len(section_words)))
    if (positive > 3 * negative or positive >= len(section_words)-1) and positive > 5:
      #debug(section_text_key)
      #debug(section_text_key+'  %d  %d  %d' % (positive, negative, len(section_words)))
      actual_section_texts.append(section_text_key)
      for section_word in section_words.keys():
        #debug(section_word)
        actual_section_words[section_word] = 1
  # Für den Fall, dass nichts erkannt wurde Alternativen abfragen
  # Dazu wird eine Alternativliste auf dem Bildschirm angezeigt
  if len(actual_section_words) == 0:
    actual_section_texts_keys = get_actual_texts_keys()
    for actual_section_text in actual_section_texts_keys:
      actual_section_texts.append(actual_section_text)
    for actual_section_text_key in actual_section_texts_keys:
      actual_section_text = section_texts[actual_section_text_key]
      for section_word in s.split(actual_section_text):
        actual_section_words[section_word.lower()] = 1
  # Falls immer noch nicht, dann Eingabe eines Textes erlauben
  if len(actual_section_words) == 0:
    actual_section_text = get_actual_text()
    # debug(actual_section_text)
    t = re.compile(r'[(,;.:!?"]*')
    actual_section_text = t.sub('', actual_section_text)
    section_texts['different text'] = actual_section_text
    actual_section_texts = ['different text']
    for section_word in s.split(actual_section_text):
      actual_section_words[section_word.lower()] = 1
  # Sonst hier abbrechen
  if len(actual_section_words) == 0:
    return
  # Ab hier liegen alle Texte vor
  all_section_texts = ''
  for actual_section_text in actual_section_texts:
    all_section_texts = all_section_texts+' '+section_texts[actual_section_text]
  all_section_texts = all_section_texts.lower()
  #debug(all_section_texts)
  # Hash erstellen, der aus einer normalisierten Form die Grundform liefert
  normalized_section_words = {} # Hier stehen Paare: m => in usw.
  # Hash erstellen, in dem zu jeder Silbe steht, wie sie gebunden werden soll
  actual_bindings = {} # Silbenbindungen zu jeder Silbe: 1 = ungebunden, 2 gebunden, 3 = gemischt
  # Jede Silbe des tatsächlichen Liedtextes durchlaufen
  for section_word in actual_section_words.keys():
    # Die Liedtextsilben normalisieren
    normalized_section_word = normalize_text(section_word)
    # Falls die normalisierte Silbe so vorkommt, dann so übernehmen
    if normalized_section_words.has_key(normalized_section_word):
      normalized_section_words[normalized_section_word].append(section_word)
    else:
      normalized_section_words[normalized_section_word] = [section_word]
    # Die Silbenbindung feststellen
    if len(all_section_texts) > 0:
      dr = re.compile(r'(^|[ (|-])'+section_word+r'([ )|,;.:!?]|$)', re.IGNORECASE)
      ds = re.compile(r'(^|[ (|-])'+section_word+'-', re.IGNORECASE)
      if dr.search(all_section_texts) and ds.search(all_section_texts):
        actual_bindings[section_word.lower()] = 3
      elif ds.search(all_section_texts):
        if actual_bindings.has_key(section_word.lower()) and actual_bindings[section_word.lower()] != 2:
          actual_bindings[section_word.lower()] = 3
        else:
          actual_bindings[section_word.lower()] = 2
      elif ds.search(all_section_texts):
        if actual_bindings.has_key(section_word.lower()) and actual_bindings[section_word.lower()] != 1:
           actual_bindings[section_word.lower()] = 3
        else:
          actual_bindings[section_word.lower()] = 1
  # Nun die einzelnen Wörter des Stückes durchsuchen
  # Dazu normalisieren, vergleichen, ob es zu der Normalform nur eine
  # Lösung gibt und sodann die Lösung wiederherstellen

  for voice in score.getElementsByTagName('voice'):
    lyricsSettings = getElement(voice, 'lyricsSettings')
    if lyricsSettings:
      font = getElement(lyricsSettings, 'font')
      if font:
        if latin1_e(font.getAttribute('color')) == '993200':
          continue
    for chord in voice.getElementsByTagName('chord'):
      for verse in chord.getElementsByTagName('verse'):
        if verse.hasChildNodes() and not(verse.lastChild is None):
          text = latin1_e(verse.lastChild.nodeValue)
          [text_prefix, text, text_suffix] = prefixes_suffixes(text)
          normalized_text = normalize_text(text)
          # Das Wort existiert in der Form bzw. in anderer Groß-/Kleinschreibung => nur noch Silbenbindung prüfen
          if actual_section_words.has_key(text) or actual_section_words.has_key(text.lower()):
            # Prüfe, ob die Bindung umgestellt werden muss (anhand actual_bindings)
            if actual_bindings.has_key(text.lower()) and actual_bindings[text.lower()] == 1:
              verse.setAttribute('hyphen', 'false')
            elif actual_bindings.has_key(text.lower()) and actual_bindings[text.lower()] == 2:
              verse.setAttribute('hyphen', 'true')
          else:
            if actual_section_words.has_key(normalized_text.lower()):
              normalized_text = normalized_text.lower()
            if normalized_section_words.has_key(normalized_text) and len(normalized_section_words[normalized_text]) == 1:
              restored_text = normalized_section_words[normalized_text][0]
              restored_text = text_prefix+restored_text+text_suffix
              verse.removeChild(verse.lastChild)
              newtext = doc.createTextNode(latin1_d(restored_text))
              verse.appendChild(newtext)
              # Prüfe, ob die Bindung umgestellt werden muss (anhand actual_bindings)
              if actual_bindings.has_key(restored_text.lower()) and actual_bindings[restored_text.lower()] == 1:
                verse.setAttribute('hyphen', 'false')
              elif actual_bindings.has_key(restored_text.lower()) and actual_bindings[restored_text.lower()] == 2:
                verse.setAttribute('hyphen', 'true')
            elif text and len(text):
              display = getElement(chord, 'display')
              if not display:
                display = createNewChild(chord, 'display')
              display.setAttribute('color', 'FE0000')
  #for a in actual_bindings.keys():
  #  if actual_bindings[a] == 3:
  #    debug(a)
  #section_texts_count = len(section_texts.keys())
  #debug(`positive`+'   '+`negative`+'   '+'   '+`section_texts_count`+'   '+section_text)
  # Versuche nun für solche Silben, die uneinheitliche Ergebnisse bezüglich der Silbenbindung liefern (Kyrie-Eleison)
  # Diese aufgrund der Nachbarn zu ergänzen
  #debug(all_section_texts)
  for voice in score.getElementsByTagName('voice'):
    lyricsSettings = getElement(voice, 'lyricsSettings')
    if lyricsSettings:
      font = getElement(lyricsSettings, 'font')
      if font:
        if latin1_e(font.getAttribute('color')) == '993200':
          continue
    for i in ['0', '1', '2', '3', '4', '5', '6', '7', '8', '9']:  # Die einzelnen Liedtextstrophen, die aktuell betrachtet werden  #, '1', '2', '3', '4', '5', '6', '7', '8', '9'
      chords = voice.getElementsByTagName('chord')
      last = ''
      for chord_i in range(chords.length):
        chord = chords[chord_i]
        # Stelle die aktuelle Liedtextsilbe fest
        current = ''
        for verse in chord.getElementsByTagName('verse'):
          if verse.getAttribute('i') == i and verse.hasChildNodes() and not(verse.lastChild is None):
            current = latin1_e(verse.lastChild.nodeValue)
            [text_prefix, current, text_suffix] = prefixes_suffixes(current)
            current = current.lower()
            if actual_bindings.has_key(current) and actual_bindings[current] == 3:
              # Stelle die nächste Liedtextsilbe fest
              next = ''
              for chord_n in range(chords.length):
                if next == '' and chord_n > chord_i:
                  chord_n = chords[chord_n]
                  for verse in chord_n.getElementsByTagName('verse'):
                    if next == '' and verse.getAttribute('i') == i and verse.hasChildNodes() and not(verse.lastChild is None):
                      next = latin1_e(verse.lastChild.nodeValue)
              #debug(last + "  " + current + "  " + next)
              # Hier Auswertung: Aufgrund last, current und next für die aktuelle Silbe die Bindung bestimmen und setzen
              # 0 => nichts machen (rot färben), 1 => keine Bindung, 2 => Bindung
              binding = 0
              last = last.replace('(', '\\[')
              last = last.replace(')', '\\]')
              current = current.replace('(', '\\[')
              current = current.replace(')', '\\]')
              next = next.replace('(', '\\[')
              next = next.replace(')', '\\]')
              last = last.replace('[', '\\[')
              last = last.replace(']', '\\]')
              current = current.replace('[', '\\[')
              current = current.replace(']', '\\]')
              next = next.replace('[', '\\[')
              next = next.replace(']', '\\]')
              next = next.replace('(', '\\[')
              next = next.replace(')', '\\]')
              last = last.replace('[', '\\[')
              last = last.replace(']', '\\]')
              current = current.replace('[', '\\[')
              current = current.replace(']', '\\]')
              last = last.replace('*', '\\*')
              last = last.replace('+', '\\+')
              last = last.replace('?', '\\?')
              #last = last.replace('.', '\\.')
              #last = last.replace('\\', '\\\\')
              current = current.replace('*', '\\*')
              current = current.replace('+', '\\+')
              current = current.replace('?', '\\?')
              #current = current.replace('.', '\\.')
              #current = current.replace('\\', '\\\\')
              next = next.replace('*', '\\*')
              next = next.replace('+', '\\+')
              next = next.replace('?', '\\?')
              #next = next.replace('.', '\\.')
              #next = next.replace('\\', '\\\\')
              s1a = re.compile(current+r"-"+next)
              s1b = re.compile(current+r" "+next)
              s2a = re.compile(last+r" "+current+r"-")
              s2b = re.compile(last+r"-"+current+r"-")
              s2c = re.compile(last+r"-"+current+r" ")
              s2d = re.compile(last+r" "+current+r" ")
              s3a = re.compile(last+r" "+current+r" ")  #!do [ )] statt einfach Leerfeld ergänzt
              s3b = re.compile(last+r"-"+current+r" ")  #!do [ )] statt einfach Leerfeld ergänzt
              s3c = re.compile(last+r"-"+current+r"-")  #!do [ )] statt einfach Leerfeld ergänzt
              s3d = re.compile(last+r" "+current+r"-")  #!do [ )] statt einfach Leerfeld ergänzt
              #if current == 'in':
              #  debug(current+' '+next+' ### '+all_section_texts)
              if next != '' and s1a.search(all_section_texts) and not s1b.search(all_section_texts):
                binding = 2
              elif last != '' and s2a.search(all_section_texts) and not s2b.search(all_section_texts) and not s2c.search(all_section_texts) and not s2d.search(all_section_texts):
                binding = 2
              elif last != '' and s2b.search(all_section_texts) and not s2a.search(all_section_texts) and not s2c.search(all_section_texts) and not s2d.search(all_section_texts):
                binding = 2
              elif last != '' and s3a.search(all_section_texts) and not s3b.search(all_section_texts) and not s3c.search(all_section_texts) and not s3d.search(all_section_texts):
                binding = 1
              elif last != '' and s3b.search(all_section_texts) and not s3a.search(all_section_texts) and not s3c.search(all_section_texts) and not s3d.search(all_section_texts):
                binding = 1
              # Falls Bindung durchgeführt werden soll, so entsprechende Liedtextsilbe suchen
              if binding == 0: # Akkord rot färben
                display = getElement(chord, 'display')
                if not display:
                  display = createNewChild(chord, 'display')
                display.setAttribute('color', 'FE0000')
              else:
                for verse in chord.getElementsByTagName('verse'):
                  if verse.getAttribute('i') == i:
                    if binding == 1:
                      verse.setAttribute('hyphen', 'false')
                    elif binding == 2:
                      verse.setAttribute('hyphen', 'true')
            last = current


class ScoreChange(ScoreChange):
  def changeScore(self, score):
    Tools.init_doc(score.parentNode)
    Optimizer.repair(score)
    Optimizer.repair_brackets(score)
    system_check(score)
    Optimizer.de_color(score)
    Optimizer.blue_lyrics(score)
    Optimizer.minus_verses(score)
    Optimizer.non_bind(score)
    # Stelle fest, welche Parts durch die Noten abgedeckt werden
    update_parts(score)
    Optimizer.repair(score)
    debug('Ready!')



if activeScore():
  activeScore().registerUndo("CapScan-Fehlersuche")
  tempInput = tempfile.mktemp('.capx')
  tempOutput = tempfile.mktemp('.capx')

  activeScore().write(tempInput)

  ScoreChange(tempInput, tempOutput)

  activeScore().read(tempOutput)
  os.remove(tempInput)
  os.remove(tempOutput)



# Noten mit Artikulationszeichen rot färben falls Liedtexte vorhanden
def lyrical_accidentals(score):
  for staff in score.getElementsByTagName('staff'):
    verse = staff.getElementsByTagName('verse')
    if verse != []:
      for chord in staff.getElementsByTagName('chord'):
        articulation = getElement(chord, 'articulation')
        if articulation:
          display = getElement(chord, 'display')
          if not display:
            display = createNewChild(chord, 'display')
          display.setAttribute('color', 'FE0000')

# Stichnoten mit Artikulationszeichen rot färben
def grace_accidentals(score):
  for chord in score.getElementsByTagName('chord'):
    duration = getElement(chord, 'duration')
    if duration.getAttribute('noDuration') == 'true':
      articulation = getElement(chord, 'articulation')
      if articulation:
        display = getElement(chord, 'display')
        if not display:
          display = createNewChild(chord, 'display')
        display.setAttribute('color', 'FE0000')


