# -*- coding: utf-8 -*-
""" capellaScript -- Matthias Leopold
>>> GuitarOptimizer

    Verschiedene mögliche Fehler und Hinweise werden durch Farben angezeigt.
    
    Die Farben werden in den Arbeitsunterlagen unter OptimizerHilfe erklärt.

<<<

History: 03.04.06 - Liedtexte, Akkordsymbole


"""

import xml.dom.minidom
from caplib.capDOM import ScoreChange
import os, re, string, sys, tempfile, zipfile
sys.path.append(os.path.join(getPersonalDataDir(), 'scripts', 'user-scripts'))
import Optimizer, Tools

import Optimizer, Tools
from Tools import latin1_e
from Tools import latin1_d
from Tools import createNewChild
from Tools import getElement
from Tools import getElements


def debug(text='Text'):
  label = Label(text)
  box = VBox([label],padding=1)
  dlg = Dialog('Debugger', box)
  if dlg.run():
    return True
  else:
    return False



# Prüft, ob es mehr Systeme im Mustersystem gibt, als irgendwann angezeigt werden
# Wenn ja -> Fehlermeldung
def system_check(score):
  global doc  # Referenz auf das Dokument
  doc = score.parentNode
  layout_systems = 0
  max_systems = 0
  for staffLayout in score.getElementsByTagName('staffLayout'):
    layout_systems += 1
  for system in score.getElementsByTagName('system'):
    current_systems = 0
    for staff in system.getElementsByTagName('staff'):
      current_systems += 1
    if current_systems > max_systems:
      max_systems = current_systems
  if max_systems < layout_systems :
    debug('Vermutlich Fehler im Mustersystem!!!')


# Eintrag {guitar} für alle Systeme erzeugen, Gitarre 1, Gitarre 2, ... eintragen, wenn mehr als ein System
def mark_guitar(score):
  # Feststellen, ob {GUITAR} schon existiert
  p = re.compile('^\s*\{\s*GUITAR\s*\}\s*$', re.I)
  guitar_nexists = 1
  for content in score.getElementsByTagName('content'):
    if content.lastChild is None:
      continue;
    ctext = latin1_e(content.lastChild.nodeValue)
    if p.search(ctext):
      guitar_nexists = 0
  # guitar_nexists = 1 => überall {GUITAR} einfügen
  if guitar_nexists == 1:
    for system in score.getElementsByTagName('system'):
      for staff in system.getElementsByTagName('staff'):
        for noteObjects in staff.getElementsByTagName('noteObjects'):
          events = getElements(noteObjects, ['rest', 'chord'])
          for event in events:
            drawObjects = createNewChild(event, 'drawObjects')
            drawObj = createNewChild(drawObjects, 'drawObj', True)
            text = createNewChild(drawObj, 'text')
            text.setAttribute('x', '-3.8')
            text.setAttribute('y', '-3.5')
            font = createNewChild(text, 'font')
            font.setAttribute('face', 'Times New Roman')
            font.setAttribute('height', '12')
            font.setAttribute('weight', '0')
            font.setAttribute('pitchAndFamily', '0')
            content = createNewChild(text, 'content')
            content.appendChild(doc.createTextNode('{GUITAR}'))
            break
          break
      break
  # Mehr als ein System => Gitarre 1, Gitarre 2 einfügen
  inames_count = 0
  # Standardname unbekannt... ist voreingestellt
  standard_names = True
  p = re.compile('^unbenannt\s*\d*$')
  descriptions = {}
  for staffLayout in score.getElementsByTagName('staffLayout'):
    inames_count += 1
    description = staffLayout.getAttribute('description')
    if not p.search(latin1_e(description)):
      standard_names = False
  if inames_count > 1 and standard_names:  # > 1 => Benennung nur ab zwei Systemen aufwärts
    i = 1
    for staffLayout in score.getElementsByTagName('staffLayout'):
      description = staffLayout.getAttribute('description')
      descriptions[latin1_e(description)] = 'Gitarre '+str(i)
      staffLayout.setAttribute('description', 'Gitarre '+str(i))
      for instrument in staffLayout.getElementsByTagName('instrument'):
        instrument.setAttribute('name', 'Gitarre '+str(i))
        instrument.setAttribute('abbrev', 'Git. '+str(i))
      i += 1
    i = 1
    for system in score.getElementsByTagName('system'):
      for staff in system.getElementsByTagName('staff'):
        description = staff.getAttribute('layout')
        staff.setAttribute('layout', descriptions[latin1_e(description)])
    for system in score.getElementsByTagName('system'):
      system.setAttribute('instrNotation', 'long')
      break



# Bögen, Winkel, Texte usw. einfärben, die unter einem System
# mit Gesangsnoten liegen (da vermutlich falsche Zuordnung)
def assignment(score):
  tolerance = 2.5  # Diese Zahl weicht ab im Vergleich zu CapScanOptimizer
  for staff in score.getElementsByTagName('staff'):
    verses = staff.getElementsByTagName('verse')
    if verses != []:
      for noteObjects in staff.getElementsByTagName('noteObjects'):
        events = getElements(noteObjects, ['rest', 'chord'])
        for event in events:
          for drawObj in event.getElementsByTagName('drawObj'):
            for text in drawObj.getElementsByTagName('text'):
              if float(latin1_e(text.getAttribute('y'))) > tolerance:
                font = getElement(text, 'font')
                font.setAttribute('color', 'FE0000')
            for wedge in drawObj.getElementsByTagName('wedge'):
              if float(latin1_e(wedge.getAttribute('y1'))) > tolerance:
                wedge.setAttribute('color', 'FE0000')



# Akzente wie sf usw rot färben, wenn die an einer Pause stehen
def accent_check(score):
  for rest in score.getElementsByTagName('rest'):
    for text in rest.getElementsByTagName('text'):
      content = getElement(text, 'content')
      if content.lastChild is None:
        continue;
      dtext = latin1_e(content.lastChild.nodeValue)
      font = getElement(text, 'font')
      if font.getAttribute('face') == 'capella3':
        if dtext == 's' or dtext == 'z' or dtext == '{':
          display = getElement(rest, 'display')
          if not display:
            display = createNewChild(rest, 'display')
          display.setAttribute('color', 'FE0000')
      else:
        if dtext == 'sf' or dtext == 'sff' or dtext == 'rfz' or dtext == 'rffz' or dtext == 'sfz' or dtext == 'sffz' or dtext == 'rf' or dtext == 'rff':
          display = getElement(rest, 'display')
          if not display:
            display = createNewChild(rest, 'display')
          display.setAttribute('color', 'FE0000')



#
# Falls ein Akkord die Eigenschaft suppress, force oder parenth hat, so
# auf alle Noten verteilen
# funktioniert nicht so, wie es soll
def support_accidental(score):
  for chord in score.getElementsByTagName('chord'):
    force = 0
    suppress = 0
    parenth = 0
    for alter in chord.getElementsByTagName('alter'):
      if alter.getAttribute('display') == 'force':
        force = 1
      if alter.getAttribute('display') == 'suppress':
        suppress = 1
      if alter.getAttribute('display') == 'parenth':
        parenth = 1
    for alter in chord.getElementsByTagName('alter'):
      if force == 1:
        alter.setAttribute('display', 'force')
      if suppress == 1:
        alter.setAttribute('display', 'suppress')
      if parenth == 1:
        alter.setAttribute('display', 'parenth')


def word_min_size(score):
  for text in score.getElementsByTagName('text'):
    content = getElement(text, 'content')
    font = getElement(text, 'font')
    length = latin1_e(font.getAttribute('height'))
    if len(length) == 1 or length == '10' or length == '11':
      font.setAttribute('height', '12')

files = {}

class ScoreChange(ScoreChange):
  def changeScore(self, score):
    score.messageBox = lambda title,msg: messageBox(title, msg)
    Tools.init_doc(score.parentNode)
    Optimizer.repair(score)
    Optimizer.repair_brackets(score)
    system_check(score)
    mark_guitar(score)
    Optimizer.general_optimize(score, files)
    Optimizer.optimize_guitar(score)
    Optimizer.set_keyword(score, 'GuitarOptimizer')
    debug('Ready!')
  def __init__(self, inputFile, outputFile=''):
    if outputFile == '':
      #outputFile = inputFile[:-5] + '~.capx'
      outputFile = inputFile[:inputFile.rfind('.')] + '~.capx'
    zr = zipfile.ZipFile(inputFile, 'r')
    zw = zipfile.ZipFile(outputFile, 'w', zipfile.ZIP_DEFLATED)
    for name in zr.namelist():
      files[name] = zr.read(name)
    for name in zr.namelist():
      t = zr.read(name)
      if name == 'score.xml':
        self.doc = xml.dom.minidom.parseString(t)
        #--- Partitur ändern und in temporärer Datei speichern
        tempFile = tempfile.mktemp('.xml')
        self.f = file(tempFile, 'wt')
        self.f.write('<?xml version="1.0" encoding="ISO-8859-1" standalone="yes"?>\n')
        self.changeScore(self.doc.documentElement)
        self.copyElement(self.doc.documentElement)
        self.f.close()
        zw.write(tempFile, 'score.xml')
        os.remove(tempFile)
      else:
        info = zipfile.ZipInfo(name)
        info.compress_type = zipfile.ZIP_DEFLATED
        zw.writestr(info, t)

if activeScore():
  activeScore().registerUndo('GuitarOptimizer')
  tempInput = tempfile.mktemp('.capx')
  tempOutput = tempfile.mktemp('.capx')

  activeScore().write(tempInput)

  ScoreChange(tempInput, tempOutput)

  activeScore().read(tempOutput)
  os.remove(tempInput)
  os.remove(tempOutput)

