# -*- coding: utf-8 -*-
""" capellaScript -- Matthias Leopold
>>> WindOptimizer

    Verschiedene mögliche Fehler und Hinweise werden durch Farben angezeigt.
    
    Die Farben werden in den Arbeitsunterlagen unter OptimizerHilfe erklärt.

<<<



"""

import xml.dom.minidom
from caplib.capDOM import ScoreChange
import os, re, string, sys, tempfile, zipfile
sys.path.append(os.path.join(getPersonalDataDir(), 'scripts', 'user-scripts'))
import Optimizer, Tools

from Tools import latin1_e
from Tools import latin1_d
from Tools import createNewChild
from Tools import getElement
from Tools import getElements

def debug(text='Text'):
  label = Label(text)
  box = VBox([label],padding=1)
  dlg = Dialog('Debugger', box)
  if dlg.run():
    return True
  else:
    return False

# Prüft, ob es mehr Systeme im Mustersystem gibt, als irgendwann angezeigt werden
# Wenn ja -> Fehlermeldung
def system_check(score):
  global doc  # Referenz auf das Dokument
  doc = score.parentNode
  layout_systems = 0
  max_systems = 0
  for staffLayout in score.getElementsByTagName('staffLayout'):
    layout_systems += 1
  for system in score.getElementsByTagName('system'):
    current_systems = 0
    for staff in system.getElementsByTagName('staff'):
      current_systems += 1
    if current_systems > max_systems:
      max_systems = current_systems
  if max_systems < layout_systems :
    debug('Vermutlich Fehler im Mustersystem!!!')


# Eintrag {guitar} für alle Systeme erzeugen, Gitarre 1, Gitarre 2, ... eintragen, wenn mehr als ein System
def mark_wind(score):
  # Feststellen, ob {GUITAR} schon existiert
  p = re.compile('^\s*\{\s*WIND\s*\}\s*$', re.I)
  guitar_nexists = 1
  for content in score.getElementsByTagName('content'):
    if content.lastChild is None:
      continue;
    ctext = latin1_e(content.lastChild.nodeValue)
    if p.search(ctext):
      guitar_nexists = 0
  # changes for all staffs or only on
  # guitar_nexists = 1 => überall {GUITAR} einfügen
  if guitar_nexists == 1:
    for system in score.getElementsByTagName('system'):
      for staff in system.getElementsByTagName('staff'):
        for noteObjects in staff.getElementsByTagName('noteObjects'):
          events = getElements(noteObjects, ['rest', 'chord'])
          for event in events:
            drawObjects = getElement(event, 'drawObjects')
            if not drawObjects:
              drawObjects = createNewChild(event, 'drawObjects')
            drawObj = createNewChild(drawObjects, 'drawObj', True)
            text = createNewChild(drawObj, 'text')
            text.setAttribute('x', '-3.8')
            text.setAttribute('y', '-3.5')
            font = createNewChild(text, 'font')
            font.setAttribute('face', 'Times New Roman')
            font.setAttribute('height', '12')
            font.setAttribute('weight', '0')
            font.setAttribute('pitchAndFamily', '0')
            content = createNewChild(text, 'content')
            content.appendChild(doc.createTextNode('{WIND}'))
            break
          break
      break
  # Mehr als ein System => Gitarre 1, Gitarre 2 einfügen
  inames_count = 0
  # Standardname unbekannt... ist voreingestellt
  standard_names = True
  p = re.compile('^unbenannt\s*\d*$')
  descriptions = {}
  for staffLayout in score.getElementsByTagName('staffLayout'):
    inames_count += 1
    description = staffLayout.getAttribute('description')
    if not p.search(latin1_e(description)):
      standard_names = False

files = {}

class ScoreChange(ScoreChange):
  def changeScore(self, score):
    Tools.init_doc(score.parentNode)
    Optimizer.repair(score)
    Optimizer.repair_brackets(score)
    system_check(score)
    mark_wind(score)
    Optimizer.optimize_wind(score, files)
    Optimizer.repair(score)
    Optimizer.set_keyword(score, 'WindOptimizer')
    debug('Ready!')
  def __init__(self, inputFile, outputFile=''):
    if outputFile == '':
      #outputFile = inputFile[:-5] + '~.capx'
      outputFile = inputFile[:inputFile.rfind('.')] + '~.capx'
    zr = zipfile.ZipFile(inputFile, 'r')
    zw = zipfile.ZipFile(outputFile, 'w', zipfile.ZIP_DEFLATED)
    for name in zr.namelist():
      files[name] = zr.read(name)
    for name in zr.namelist():
      t = zr.read(name)
      if name == 'score.xml':
        self.doc = xml.dom.minidom.parseString(t)
        #--- Partitur ändern und in temporärer Datei speichern
        tempFile = tempfile.mktemp('.xml')
        self.f = file(tempFile, 'wt')
        self.f.write('<?xml version="1.0" encoding="ISO-8859-1" standalone="yes"?>\n')
        self.changeScore(self.doc.documentElement)
        self.copyElement(self.doc.documentElement)
        self.f.close()
        zw.write(tempFile, 'score.xml')
        os.remove(tempFile)
      else:
        info = zipfile.ZipInfo(name)
        info.compress_type = zipfile.ZIP_DEFLATED
        zw.writestr(info, t)

if activeScore():
  activeScore().registerUndo('WindOptimizer')
  tempInput = tempfile.mktemp('.capx')
  tempOutput = tempfile.mktemp('.capx')

  activeScore().write(tempInput)

  ScoreChange(tempInput, tempOutput)
  
  activeScore().read(tempOutput)
  os.remove(tempInput)
  os.remove(tempOutput)

